#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fireworks by MendiMod01.fsh   by  Mendi80   
//https://www.shadertoy.com/view/7ddGRn
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define NUM_EXPLOSIONS 7.
#define NUM_PARTICLES 100.
#define inv_nparticels (1./NUM_PARTICLES)
#define PI 3.1415926

float Hash11(float t){
    return fract(sin(t*613.2)*614.8);
}
vec2 Hash12(float t){
  return vec2(fract(sin(t*213.3)*314.8)-0.5,fract(sin(t*591.1)*647.2)-0.5);
}

vec2 Hash12_Polar(float t){
    float o = fract(sin(t*213.3)*314.8)*PI*2.0;
    float r = fract(sin(t*591.1)*647.2);
    return vec2(sin(o)*r,cos(o)*r);
}

float Explosion(vec2 uv, float t)
{
    float fract_t=fract(t);
    float floor_t=floor(t);
    float power=0.3+Hash11(floor_t);
    float sparks=0.;
    for(float i=0.;i<NUM_PARTICLES;i++)
    {
        vec2 dir=Hash12_Polar(i*floor_t)*1.;
        float inv_d=1./(length(uv-dir*sqrt(fract_t)));
        float brightness=mix(0.3,0.09,smoothstep(0.,0.1,fract_t))*(1.0-(0.5+0.5*Hash11(i))*fract_t);
        float sparkling= .5+.5*sin(t*10.2+floor_t*i);
        sparks+=power*brightness*sparkling*inv_nparticels*inv_d;
    }
    return sparks;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;

    vec3 col=vec3(0);    

    for(float i=0.;i<NUM_EXPLOSIONS;i++){
        float t=iTime*(0.3+0.4*Hash11(i))+i/NUM_EXPLOSIONS;
        float fract_t=fract(t);
        float floor_t=floor(t);
    
        vec3 color=0.7+0.3*sin(vec3(.34,.54,.43)*floor_t*i);
        vec2 center = Hash12(i+10.+5.*floor_t);
        col+=Explosion(uv-center,t)*color;
    }
    col-=0.1;
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

